package gov.va.vinci.dart.json.atom;

import org.springframework.stereotype.Component;

@Component
public class AtomLinkFactory {

	private boolean initialized = false;
	private String URIBase;
	
	public void setURIBase(final String uri) {
		if (initialized == false) {
			int idx = uri.lastIndexOf('/');
			if (idx > 0) {
				URIBase = uri.substring(0,idx);
				initialized = true;
			}
		}
	}
	
	public LinkView buildLink(final String relativeURI, final String relation) {
		LinkView result = new LinkView();
		result.setType("AtomLink");
		result.setRel(relation);
		if (relativeURI.startsWith("")) {
			result.setHref(URIBase + relativeURI);
		}
		else {
			result.setHref(URIBase + "/" + relativeURI);
		}
		
		return result;
	}
}
